//Uncomment below if using Halo
#define HALO_QSPI

#ifndef HALO_QSPI
//if using PSE, Vybrid, etc
#include "Halo.h"
#include "faraday.h"
#define ARDB (*(volatile unsigned int *) 0x7C000000)
#define QuadSPI_X QuadSPI_0
#else
//Using Halo
//#include "MAC57D54H.h"
//#include "halo_ports.h"
//Note: we use quadspi 1 beacuse is connected to standard qspi (no rpc) on that port
//#define QuadSPI_X QuadSPI_1
//#define ARDB (*(volatile unsigned int *) 0x71800000)
#define QuadSPI_X QuadSPI_0
#define ARDB (*(volatile unsigned int *) 0x71000000)
#endif

#define FLASH_BASE_ADR	0x20000000
#define FLASH_BASE_ADR2	0x21000000


void QSPI_setup(void);
void quadspi_eraseA(void);
void quadspi_eraseB(void);
void quadspi_program(unsigned long src, unsigned long base, unsigned long size);
void quadspi_programA(unsigned long src, unsigned long base, unsigned long size);
void quadspi_programB(unsigned long src, unsigned long base, unsigned long size);
void setup_LUT_Q0(void);
void quadspi_wait_while_flash_busy(void);
void quadspi_enable_quad_bit(void);

/////////////////required defines to compile //////////////////////////////////
#define BURST_SIZE 0x80 //max 256bytes!
//#define FLASH_PGSZ	0x100	// 256 B
#define FLASH_PGSZ	(64)	// 256 B

/* QUADSPI Instructions */
#define CMD 1
#define ADDR 2
#define DUMMY 3
#define MODE 4
#define MODE2 5
#define MODE4 6
#define READ 7
#define WRITE 8
#define JMP_ON_CS 9
#define ADDR_DDR 10
#define MODE_DDR 11
#define MODE2_DDR 12
#define MODE4_DDR 13
#define READ_DDR 14
#define WRITE_DDR 15
#define DATA_LEARN 16
#define STOP 0


#define QuadSPI_SR_BUSY_SHIFT                (0)  
#define QuadSPI_SR_BUSY_MASK                 ((1) << (QuadSPI_SR_BUSY_SHIFT)) 
#define QuadSPI_MCR_CLR_TXF_MASK             0x800u
#define QSPI_SR_RXWE_SHIFT                (16)  
#define QSPI_SR_RXWE_MASK                 ((1) << (QSPI_SR_RXWE_SHIFT)) 
#define QuadSPI_MCR_CLR_TXF_MASK                 0x800u
#define QuadSPI_MCR_CLR_TXF_SHIFT                11
#define QuadSPI_SR_TXFULL_MASK                   0x8000000u
#define QuadSPI_SR_TXFULL_SHIFT                  27

#define byte_swap32(word) \
  ( ((word&0x000000FF) << 24)|			\
  ((word&0x0000FF00) << 8) |			\
  ((word&0x00FF0000) >> 8) |			\
  ((word&0xFF000000) >> 24)  )
    
#define byte_swap32A(word1,word2) \
  ( ((word1&0x000000F0) << 24)|			\
  ((word1&0x0000F000) << 12) |			\
  ((word1&0x00F00000) >> 0) |			\
  ((word1&0xF0000000) >> 12) |                  \
  ((word2&0x000000F0) << 8)|			\
  ((word2&0x0000F000) >> 4) |			\
  ((word2&0x00F00000) >> 16) |			\
  ((word2&0xF0000000) >> 28) )    

#define byte_swap32B(word1,word2) \
  ( ((word1&0x0000000F) << 28)|			\
  ((word1&0x00000F00) << 16) |			\
  ((word1&0x000F0000) << 4) |			\
  ((word1&0x0F000000) >> 8) |                  \
  ((word2&0x0000000F) << 12)|			\
  ((word2&0x00000F00) >> 0) |			\
  ((word2&0x000F0000) >> 12) |			\
  ((word2&0x0F000000) >> 24) )            


